
implementation module WormsGfx

import StdEnv, StdGameDef

OBJ_START :== 0x10

Level1Bitmap :: GameBitmap
Level1Bitmap
  = { bitmapname  = "bitmaps\\Level1.bmp"
    , unitsize    = { w = 24, h = 24 }
    , dimensions  = (8, 2)
    , transparent = Just { x = 168, y = 24 }
    }

Level1Map1Map :: [{#Int}]
Level1Map1Map =
  [{  1,  2,  3,  3,  4,  3,  5,  2,  5,  3,  5,  3,  4,  3,  5,  5,  3,  4,
      5,  3,  2,  3,  5,  4,  3,  3,  2,  1},
   {  1,  3,  6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  8,  3,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  5,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  5,  1},
   {  1,  2,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  2,  1},
   {  1,  5,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  5,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  5,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  5,  1},
   {  1,  2,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  4,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  3, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 15,  3,  1},
   {  1,  4,  3,  3,  4,  3,  5,  5,  2,  3,  5,  3,  2,  3,  3,  4,  3,  5,
      2,  5,  3,  5,  3,  4,  3,  3,  4,  1}]

Level1Map1BoundMapData :: [{#Int}]
Level1Map1BoundMapData =
  [{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15}]

Level1Map1BoundMap :: BoundMap
Level1Map1BoundMap
  = { map       = Level1Map1BoundMapData
    , blocksize = { w = 24, h = 24 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

Level1Map1WideBoundMap :: BoundMap
Level1Map1WideBoundMap
  = { Level1Map1BoundMap 
    & startobjx = 28
    , startobjy = 20
    }



Level1Sequences :: [(Int, [(Int, Int)])]
Level1Sequences = 
  [
  ]

Level1Map1Layer :: Layer
Level1Map1Layer
  = { bmp       = Level1Bitmap
    , layermap  = Level1Map1Map
    , sequences = Level1Sequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

Level2Bitmap :: GameBitmap
Level2Bitmap
  = { bitmapname  = "bitmaps\\Level2.bmp"
    , unitsize    = { w = 24, h = 24 }
    , dimensions  = (9, 2)
    , transparent = Just { x = 168, y = 24 }
    }

Level2Map1Map :: [{#Int}]
Level2Map1Map =
  [{  1,  2,  3,  3,  4,  3,  5,  2,  5,  3,  5,  3,  4,  3,  5,  5,  3,  4,
      5,  3,  2,  3,  5,  4,  3,  3,  2,  1},
   {  1,  3,  6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  8,  3,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  5,  9, 10, 11, 11, 10, 10, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13,
     13, 10, 11, 11, 10, 10, 11, 12,  5,  1},
   {  1,  2,  9, 10, 11, 11, 10, 10, 12,  3,  5,  4,  2,  3,  5,  4,  3,  2,
      3,  9, 11, 11, 10, 10, 11, 12,  2,  1},
   {  1,  5,  9, 11, 10, 10, 11, 11, 10,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      7, 11, 10, 10, 11, 11, 10, 12,  5,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  5,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  5,  1},
   {  1,  2,  9, 11, 10, 10, 11, 11, 10, 13, 13, 13, 13, 13, 13, 13, 13, 13,
     13, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 12,  3,  2,  5,  3,  4,  3,  5,  2,  5,
      3,  9, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1, 14,  9, 10, 11, 11, 10, 10, 11,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      7, 10, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  3, 15, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 16,  3,  1},
   {  1,  4,  3,  3,  4,  3,  5,  5,  2,  3,  5,  3,  2,  3,  3,  4,  3,  5,
      2,  5,  3,  5,  3,  4,  3,  3, 14,  1}]

Level2Map1BoundMapData :: [{#Int}]
Level2Map1BoundMapData =
  [{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 32783, 32783, 32783, 32783, 32783, 32783,
     32783, 32783, 32783, 0, 0, 0, 0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 32783, 32783, 32783, 32783, 32783, 32783,
     32783, 32783, 32783, 0, 0, 0, 0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15}]

Level2Map1BoundMap :: BoundMap
Level2Map1BoundMap
  = { map       = Level2Map1BoundMapData
    , blocksize = { w = 24, h = 24 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

Level2Map1WideBoundMap :: BoundMap
Level2Map1WideBoundMap
  = { Level2Map1BoundMap 
    & startobjx = 28
    , startobjy = 20
    }



Level2Sequences :: [(Int, [(Int, Int)])]
Level2Sequences = 
  [
  ]

Level2Map1Layer :: Layer
Level2Map1Layer
  = { bmp       = Level2Bitmap
    , layermap  = Level2Map1Map
    , sequences = Level2Sequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

Level3Bitmap :: GameBitmap
Level3Bitmap
  = { bitmapname  = "bitmaps\\Level3.bmp"
    , unitsize    = { w = 24, h = 24 }
    , dimensions  = (8, 2)
    , transparent = Just { x = 168, y = 24 }
    }

Level3Map1Map :: [{#Int}]
Level3Map1Map =
  [{  1,  2,  3,  3,  4,  3,  5,  2,  5,  2,  5,  3,  4,  3,  5,  5,  3,  4,
      5,  3,  2,  3,  5,  4,  3,  3,  2,  1},
   {  1,  3,  6,  7,  7,  7,  7,  7,  8,  3,  6,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  8,  3,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 12,  3,  9, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 12,  4,  9, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 12,  3,  9, 11, 10, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  5,  9, 10, 11, 11, 10, 10, 12,  5,  9, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  5,  1},
   {  1,  2,  9, 10, 11, 11, 10, 13, 14,  2, 15, 13, 13, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  2,  1},
   {  1,  5,  9, 11, 10, 10, 12,  2,  5,  4,  3,  3,  2,  9, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  5,  1},
   {  1,  3,  9, 11, 10, 10, 11,  7,  7,  7,  7,  7,  7, 10, 11, 11, 10, 10,
     11, 11, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
     10, 10, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  5,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 13, 13, 13,
     13, 13, 13, 10, 11, 11, 10, 12,  5,  1},
   {  1,  2,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 12,  2,  3,  5,
      4,  3,  2,  9, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10,  7,  7,  8,
      2,  6,  7, 11, 10, 10, 11, 12,  3,  1},
   {  1,  4,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 12,
      3,  9, 11, 11, 10, 10, 11, 12,  4,  1},
   {  1,  3,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 12,
      3,  9, 10, 10, 11, 11, 10, 12,  3,  1},
   {  1,  4,  9, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 12,
      4,  9, 10, 10, 11, 11, 10, 12,  4,  1},
   {  1,  3,  9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 12,
      3,  9, 11, 11, 10, 10, 11, 12,  3,  1},
   {  1,  3, 15, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14,
      5, 15, 13, 13, 13, 13, 13, 14,  3,  1},
   {  1,  4,  3,  3,  4,  3,  5,  5,  2,  3,  5,  3,  2,  3,  3,  4,  3,  5,
      2,  5,  3,  5,  3,  4,  3,  3,  4,  1}]

Level3Map1BoundMapData :: [{#Int}]
Level3Map1BoundMapData =
  [{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 32783, 32783, 32783, 32783, 32783, 32783, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 32783, 32783, 32783,
     32783, 32783, 0, 0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32783, 0, 0, 0,
     0, 0, 0, 0, 15, 15},
   { 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15}]

Level3Map1BoundMap :: BoundMap
Level3Map1BoundMap
  = { map       = Level3Map1BoundMapData
    , blocksize = { w = 24, h = 24 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

Level3Map1WideBoundMap :: BoundMap
Level3Map1WideBoundMap
  = { Level3Map1BoundMap 
    & startobjx = 28
    , startobjy = 20
    }



Level3Sequences :: [(Int, [(Int, Int)])]
Level3Sequences = 
  [
  ]

Level3Map1Layer :: Layer
Level3Map1Layer
  = { bmp       = Level3Bitmap
    , layermap  = Level3Map1Map
    , sequences = Level3Sequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

SegmentBitmap :: GameBitmap
SegmentBitmap
  = { bitmapname  = "bitmaps\\Segment.bmp"
    , unitsize    = { w = 24, h = 24 }
    , dimensions  = (1, 1)
    , transparent = Just { x = 0, y = 0 }
    }

SegmentWormSegmentMap :: [{#Int}]
SegmentWormSegmentMap =
  [{  0,  0,  0,  0},
   {  0, -1,  1,  0},
   {  0,  0,  0,  0}]

SegmentWormSegmentBoundMapData :: [{#Int}]
SegmentWormSegmentBoundMapData =
  [{ 0, 0, 0, 0},
   { 0, 0, 0, 0},
   { 0, 0, 0, 0}]

SegmentWormSegmentBoundMap :: BoundMap
SegmentWormSegmentBoundMap
  = { map       = SegmentWormSegmentBoundMapData
    , blocksize = { w = 24, h = 24 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

SegmentWormSegmentWideBoundMap :: BoundMap
SegmentWormSegmentWideBoundMap
  = { SegmentWormSegmentBoundMap 
    & startobjx = 4
    , startobjy = 3
    }


SegmentSeq1 :: (Int, [(Int, Int)])
SegmentSeq1 =
  (-1, [(1, 25), (1, 25)])

SegmentSequences :: [(Int, [(Int, Int)])]
SegmentSequences = 
  [
    SegmentSeq1
  ]

SegmentWormSegmentLayer :: Layer
SegmentWormSegmentLayer
  = { bmp       = SegmentBitmap
    , layermap  = SegmentWormSegmentMap
    , sequences = SegmentSequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

WormSegmentSprite1 :: Sprite
WormSegmentSprite1
 = { bitmap = SegmentBitmap
   , sequence = [(1, 25), (1, 25)]
   , loop = True
   }
WormSegmentAnimation1 :: Sprite
WormSegmentAnimation1
   = { WormSegmentSprite1 & loop = False }

HeadBitmap :: GameBitmap
HeadBitmap
  = { bitmapname  = "bitmaps\\Head.bmp"
    , unitsize    = { w = 28, h = 28 }
    , dimensions  = (4, 1)
    , transparent = Just { x = 0, y = 0 }
    }

HeadWormHeadMap :: [{#Int}]
HeadWormHeadMap =
  [{  0,  0,  0,  0},
   {  0, -1,  1,  0},
   {  0, -2,  2,  0},
   {  0, -3,  3,  0},
   {  0, -4,  4,  0},
   {  0,  0,  0,  0}]

HeadWormHeadBoundMapData :: [{#Int}]
HeadWormHeadBoundMapData =
  [{ 0, 0, 0, 0},
   { 0, 0, 0, 0},
   { 0, 0, 0, 0},
   { 0, 0, 0, 0},
   { 0, 0, 0, 0},
   { 0, 0, 0, 0}]

HeadWormHeadBoundMap :: BoundMap
HeadWormHeadBoundMap
  = { map       = HeadWormHeadBoundMapData
    , blocksize = { w = 28, h = 28 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

HeadWormHeadWideBoundMap :: BoundMap
HeadWormHeadWideBoundMap
  = { HeadWormHeadBoundMap 
    & startobjx = 4
    , startobjy = 6
    }


HeadSeq1 :: (Int, [(Int, Int)])
HeadSeq1 =
  (-1, [(1, 25), (1, 25)])
HeadSeq2 :: (Int, [(Int, Int)])
HeadSeq2 =
  (-2, [(2, 25), (2, 25)])
HeadSeq3 :: (Int, [(Int, Int)])
HeadSeq3 =
  (-3, [(3, 25), (3, 25)])
HeadSeq4 :: (Int, [(Int, Int)])
HeadSeq4 =
  (-4, [(4, 25), (4, 25)])

HeadSequences :: [(Int, [(Int, Int)])]
HeadSequences = 
  [
    HeadSeq1,
    HeadSeq2,
    HeadSeq3,
    HeadSeq4
  ]

HeadWormHeadLayer :: Layer
HeadWormHeadLayer
  = { bmp       = HeadBitmap
    , layermap  = HeadWormHeadMap
    , sequences = HeadSequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

WormHeadSprite1 :: Sprite
WormHeadSprite1
 = { bitmap = HeadBitmap
   , sequence = [(1, 25), (1, 25)]
   , loop = True
   }
WormHeadAnimation1 :: Sprite
WormHeadAnimation1
   = { WormHeadSprite1 & loop = False }

WormHeadSprite2 :: Sprite
WormHeadSprite2
 = { bitmap = HeadBitmap
   , sequence = [(2, 25), (2, 25)]
   , loop = True
   }
WormHeadAnimation2 :: Sprite
WormHeadAnimation2
   = { WormHeadSprite2 & loop = False }

WormHeadSprite3 :: Sprite
WormHeadSprite3
 = { bitmap = HeadBitmap
   , sequence = [(3, 25), (3, 25)]
   , loop = True
   }
WormHeadAnimation3 :: Sprite
WormHeadAnimation3
   = { WormHeadSprite3 & loop = False }

WormHeadSprite4 :: Sprite
WormHeadSprite4
 = { bitmap = HeadBitmap
   , sequence = [(4, 25), (4, 25)]
   , loop = True
   }
WormHeadAnimation4 :: Sprite
WormHeadAnimation4
   = { WormHeadSprite4 & loop = False }

FoodBitmap :: GameBitmap
FoodBitmap
  = { bitmapname  = "bitmaps\\Food.bmp"
    , unitsize    = { w = 24, h = 24 }
    , dimensions  = (2, 1)
    , transparent = Just { x = 0, y = 0 }
    }

FoodFoodMap :: [{#Int}]
FoodFoodMap =
  [{  0,  0,  0,  0,  0},
   {  0, -1,  1,  2,  0},
   {  0,  0,  0,  0,  0}]

FoodFoodBoundMapData :: [{#Int}]
FoodFoodBoundMapData =
  [{ 0, 0, 0, 0, 0},
   { 0, 0, 8960, 8960, 0},
   { 0, 0, 0, 0, 0}]

FoodFoodBoundMap :: BoundMap
FoodFoodBoundMap
  = { map       = FoodFoodBoundMapData
    , blocksize = { w = 24, h = 24 }
    , objstart  = OBJ_START
    , startobjx = 1
    , startobjy = 1
    }

FoodFoodWideBoundMap :: BoundMap
FoodFoodWideBoundMap
  = { FoodFoodBoundMap 
    & startobjx = 5
    , startobjy = 3
    }


FoodSeq1 :: (Int, [(Int, Int)])
FoodSeq1 =
  (-1, [(1, 35), (2, 35)])

FoodSequences :: [(Int, [(Int, Int)])]
FoodSequences = 
  [
    FoodSeq1
  ]

FoodFoodLayer :: Layer
FoodFoodLayer
  = { bmp       = FoodBitmap
    , layermap  = FoodFoodMap
    , sequences = FoodSequences
    , movement  = \p=:{x, y} t -> {x = x, y = y} 
    }

FoodSprite1 :: Sprite
FoodSprite1
 = { bitmap = FoodBitmap
   , sequence = [(1, 35), (2, 35)]
   , loop = True
   }
FoodAnimation1 :: Sprite
FoodAnimation1
   = { FoodSprite1 & loop = False }

